from PIL import Image


def makeDroste(baseImage, stopAfter=10):
    # Jeżeli łańcuch znaków baseImage zawiera nazwę obrazka, to wczytuję ten obrazek:
    if isinstance(baseImage, str):
        baseImage = Image.open(baseImage)

    if stopAfter == 0:
        # PRZYPADEK BAZOWY
        return baseImage

    # # Magenta to kolor z maksymalnymi wartościami składowych czerwonej, niebieskiej i alfa oraz zerową zieloną składową:
    if baseImage.mode == 'RGBA':
        magentaColor = (255, 0, 255, 255)
    elif baseImage.mode == 'RGB':
        magentaColor = (255, 0, 255)

    # Znajdowanie wymiarów obrazka i jego magentowego fragmentu:
    baseImageWidth, baseImageHeight = baseImage.size
    magentaLeft = None
    magentaRight = None
    magentaTop = None
    magentaBottom = None

    for x in range(baseImageWidth):
        for y in range(baseImageHeight):
            if baseImage.getpixel((x, y)) == magentaColor:
                if magentaLeft is None or x < magentaLeft:
                    magentaLeft = x
                if magentaRight is None or x > magentaRight:
                    magentaRight = x
                if magentaTop is None or y < magentaTop:
                    magentaTop = y
                if magentaBottom is None or y > magentaBottom:
                    magentaBottom = y

    if magentaLeft is None:
        # PRYPADEK BAZOWY — Brak pikseli w kolorze magenty.
        return baseImage

    # Generowanie obrazka o mniejszym rozmiarze:
    magentaWidth = magentaRight - magentaLeft + 1
    magentaHeight = magentaBottom - magentaTop + 1
    baseImageAspectRatio = baseImageWidth / baseImageHeight
    magentaAspectRatio = magentaWidth / magentaHeight

    if baseImageAspectRatio < magentaAspectRatio:
        # Dopasowywanie szerokości mniejszego obrazka do szerokości magentowego obszaru:
        widthRatio = magentaWidth / baseImageWidth
        resizedImage = baseImage.resize((magentaWidth,
        int(baseImageHeight * widthRatio) + 1), Image.Resampling.NEAREST)
    else:
        # Dopasowywanie wysokości mniejszego obrazka do wysokości magentowego obszaru:
        heightRatio =  magentaHeight / baseImageHeight
        resizedImage = baseImage.resize((int(baseImageWidth *
        heightRatio) + 1, magentaHeight), Image.Resampling.NEAREST)

    # Umieszczenie mniejszego obrazka w magentowym obszarze:
    for x in range(magentaLeft, magentaRight + 1):
        for y in range(magentaTop, magentaBottom + 1):
            if baseImage.getpixel((x, y)) == magentaColor:
                pix = resizedImage.getpixel((x - magentaLeft, y - magentaTop))
                baseImage.putpixel((x, y), pix)

    # PRZYPADEK REKURENCYJNY:
    return makeDroste(baseImage, stopAfter=stopAfter - 1)


recursiveImage = makeDroste('museum.png')
recursiveImage.save('museum-recursive.png')
recursiveImage.show()
